% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sv.R
\name{read_sv_as_rs}
\alias{read_sv_as_rs}
\title{Read Structural Variation Data as RS object}
\usage{
read_sv_as_rs(input)
}
\arguments{
\item{input}{a \code{data.frame} or a file with the following columns:
"sample", "chr1", "start1", "end1", "chr2", "start2", "end2", "strand1", "strand2", "svclass"}
}
\value{
a \code{list}
}
\description{
Read Structural Variation Data as RS object
}
\examples{
sv <- readRDS(system.file("extdata", "toy_sv.rds", package = "sigminer", mustWork = TRUE))
rs <- read_sv_as_rs(sv)
\donttest{
tally_rs <- sig_tally(rs)
}
}
