% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sig_exposure.R
\name{get_sig_exposure}
\alias{get_sig_exposure}
\title{Get Signature Exposure from 'Signature' Object}
\usage{
get_sig_exposure(
  Signature,
  type = c("absolute", "relative"),
  rel_threshold = 0.01
)
}
\arguments{
\item{Signature}{a \code{Signature} object obtained either from \link{sig_extract} or \link{sig_auto_extract},
or just a raw exposure matrix with column representing samples (patients) and row
representing signatures.}

\item{type}{'absolute' for signature exposure and 'relative' for signature relative exposure.}

\item{rel_threshold}{only used when type is 'relative', relative exposure less
than (\code{<=}) this value will be set to 0 and thus all signature exposures
may not sum to 1. This is similar to this argument in \link{sig_fit}.}
}
\value{
a \code{data.table}
}
\description{
The expected number of mutations (or copy number segment records) with each signature was
determined after a scaling transformation V ~ WH = W'H' where W' = WU' and H' = UH.
The scaling matrix U is a KxK diagnal matrix (K is signature number, U' is the inverse of U)
with the element corresponding to the L1-norm of column vectors of W
(ie. the sum of the elements of the vector). As a result, the k-th row vector of the final
matrix H' represents the absolute exposure (activity) of the k-th process across samples
(e.g., for SBS, the estimated (or expected) number of mutations generated by the k-th process).
Of note, for copy number signatures, only components of feature CN was used for calculating H'.
}
\examples{
# Load mutational signature
load(system.file("extdata", "toy_mutational_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Get signature exposure
expo1 <- get_sig_exposure(sig2)
expo1
expo2 <- get_sig_exposure(sig2, type = "relative")
expo2
}
\references{
Kim, Jaegil, et al. "Somatic ERCC2 mutations are associated with a distinct genomic signature in urothelial tumors."
Nature genetics 48.6 (2016): 600.
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
