% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_enrichment.R
\name{group_enrichment}
\alias{group_enrichment}
\title{General Group Enrichment Analysis}
\usage{
group_enrichment(
  df,
  grp_vars = NULL,
  enrich_vars = NULL,
  cross = TRUE,
  co_method = c("t.test", "wilcox.test"),
  ref_group = NA
)
}
\arguments{
\item{df}{a \code{data.frame}.}

\item{grp_vars}{character vector specifying group variables to split samples
into subgroups (at least 2 subgroups, otherwise this variable will be skipped).}

\item{enrich_vars}{character vector specifying measure variables to be compared.
If variable is not numeric, only binary cases are accepted in the form of
\code{TRUE/FALSE} or \code{P/N} (P for positive cases and N for negative cases).
Of note, \code{NA} values set to negative cases.}

\item{cross}{logical, default is \code{TRUE}, combine all situations provided by
\code{grp_vars} and \code{enrich_vars}. For examples, \code{c('A', 'B')} and \code{c('C', 'D')}
will construct 4 combinations(i.e. "AC", "AD", "BC" and "BD"). A variable can
not be in both \code{grp_vars} and \code{enrich_vars}, such cases will be automatically
drop. If \code{FALSE}, use pairwise combinations, see section "examples" for use cases.}

\item{co_method}{test method for continuous variable, default is 't.test'.}

\item{ref_group}{reference group set in \code{grp_vars}.}
}
\value{
a \code{data.table} with following columns:
\itemize{
\item \code{grp_var}: group variable name.
\item \code{enrich_var}: enrich variable (variable to be compared) name.
\item \code{grp1}: the first group name, should be a member in \code{grp_var} column.
\item \code{grp2}: the remaining samples, marked as 'Rest'.
\item \code{grp1_size}: sample size for \code{grp1}.
\item \code{grp1_pos_measure}: for binary variable, it stores the proportion of
positive cases in \code{grp1}; for continuous variable, it stores mean value.
\item \code{grp2_size}: sample size for \code{grp2}.
\item \code{grp2_pos_measure}: same as \code{grp1_pos_measure} but for \code{grp2}.
\item \code{measure_observed}: for binary variable, it stores odds ratio;
for continuous variable, it stores scaled mean ratio.
\item \code{measure_tested}: only for binary variable, it stores
estimated odds ratio and its 95\% CI from \code{fisher.test()}.
\item \code{p_value}: for binary variable, it stores p value from \code{fisher.test()};
for continuous variable, it stores value from \code{wilcox.test()} or \code{t.test()}.
\item \code{type}: one of "binary" and "continuous".
\item \code{method}: one of "fish.test", "wilcox.test" and "t.test".
}
}
\description{
This function takes a \code{data.frame} as input, compares proportion of positive
cases or mean measure in one subgroup and the remaining samples.
}
\examples{
set.seed(1234)
df <- dplyr::tibble(
  g1 = factor(abs(round(rnorm(99, 0, 1)))),
  g2 = rep(LETTERS[1:4], c(50, 40, 8, 1)),
  e1 = sample(c("P", "N"), 99, replace = TRUE),
  e2 = rnorm(99)
)

print(str(df))
print(head(df))

# Compare g1:e1, g1:e2, g2:e1 and g2:e2
x1 <- group_enrichment(df, grp_vars = c("g1", "g2"), enrich_vars = c("e1", "e2"))
x1

# Only compare g1:e1, g2:e2
x2 <- group_enrichment(df,
  grp_vars = c("g1", "g2"),
  enrich_vars = c("e1", "e2"),
  co_method = "wilcox.test",
  cross = FALSE
)
x2

\donttest{
# Visualization
p1 <- show_group_enrichment(x1, fill_by_p_value = TRUE)
p1
p2 <- show_group_enrichment(x1, fill_by_p_value = FALSE)
p2
p3 <- show_group_enrichment(x1, return_list = TRUE)
p3
}
}
\seealso{
\link{show_group_enrichment}
}
