% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{add_ROC_derived_columns}
\alias{add_ROC_derived_columns}
\title{Add ROC derived columns.}
\usage{
add_ROC_derived_columns(d, positive_prevalence)
}
\arguments{
\item{d}{input data frame, must at lest of columns Sensitivity and Specificity}

\item{positive_prevalence}{scalar, the prevalence of the positive class or prior odds}
}
\value{
extended data frame with more columns
}
\description{
Add ROC columns derived from sensitivity and specificity.
}
\examples{

d <- data.frame(pred = 1:4, truth = c(TRUE,FALSE,TRUE,TRUE))
roc <- build_ROC_curve(d$pred, d$truth)
add_ROC_derived_columns(roc, mean(d$truth))

}
