% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SC-model.R
\name{SC}
\alias{SC}
\alias{SC.default}
\alias{SC.TRI}
\alias{SC.pslg}
\title{The universal model}
\usage{
SC(x, ...)

\method{SC}{default}(x, ...)

\method{SC}{TRI}(x, ...)

\method{SC}{pslg}(x, ...)
}
\arguments{
\item{x}{input model}

\item{...}{arguments passed to methods}
}
\value{
SC model with tables 'object', 'object_link_edge', 'edge', and 'vertex'
}
\description{
The universal model \code{SC} is coordinates and binary relations between
pairs of coordinates. This is purely an edge (or segment) model, with all
higher level structures recorded as groupings of edges.
}
\examples{
## we can produce a high quality triangulation from a low quality one
## see how the TRI edges are maintained (we can't yet filter out holes from DEL)
tri <- TRI(minimal_mesh)
plot(tri)
plot(SC(tri))
}
