% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{silv_sqrmean_diameter}
\alias{silv_sqrmean_diameter}
\title{Calculates the squared mean diameter}
\usage{
silv_sqrmean_diameter(diameter, ntrees = NULL)
}
\arguments{
\item{diameter}{Numeric vector of diameters or diameter classes}

\item{ntrees}{Numeric vector with number of trees of the diameter class per
hectare. If \code{ntrees = NULL}, the function will assume that each diameter
corresponds to only one tree. Therefore, basal area will be calculated
for each individual tree}
}
\value{
A numeric vector
}
\description{
Calculates the squared mean diameter
}
\examples{
## calculate dg for inventory data grouped by plot_id and species
library(dplyr)
inventory_samples |>
mutate(dclass = silv_diametric_class(diameter)) |>
  summarise(
    height = mean(height, na.rm = TRUE),
    ntrees = n(),
    .by    = c(plot_id, species, dclass)
  ) |>
  mutate(
    ntrees_ha = silv_ntrees_ha(ntrees, plot_size = 10),
    h0        = silv_dominant_height(dclass, height, ntrees_ha),
    dg        = silv_sqrmean_diameter(dclass, ntrees_ha),
    .by       = c(plot_id, species)
  )

## calculate dg for a vector of diameters
silv_sqrmean_diameter(c(12.5, 23.5, 14, 16, 18.5))
}
