% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vbeta}
\alias{vbeta}
\title{Variate Generation for Beta Distribution}
\usage{
vbeta(
  n,
  shape1,
  shape2,
  ncp = 0,
  stream = NULL,
  antithetic = FALSE,
  asList = FALSE
)
}
\arguments{
\item{n}{number of observations}

\item{shape1}{Shape parameter 1 (alpha)}

\item{shape2}{Shape parameter 2 (beta)}

\item{ncp}{Non-centrality parameter (default 0)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via 
\code{\link[=qbeta]{stats::qbeta}};
otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qbeta]{stats::qbeta}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

  Otherwise, return a list with components suitable for visualizing inversion,
  specifically:
    \item{u}{        A vector of generated U(0,1) variates }
    \item{x}{        A vector of beta random variates }
    \item{quantile}{ Parameterized quantile function }
    \item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Beta Distribution
}
\details{
Generates random variates from the beta distribution.

  Beta variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}}
  (if \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qbeta]{stats::qbeta}} is used to
  invert the uniform(0,1) variate(s).
  In this way, using \code{vbeta} provides a monotone and synchronized
  binomial variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

The beta distribution has density

    \deqn{f(x) = \frac{\Gamma(a+b)}{\Gamma(a) \ \Gamma(b)} x^{a-1}(1-x)^{b-1}}{%
          f(x) = Gamma(a+b)/(Gamma(a)Gamma(b)) x^(a-1)(1-x)^(b-1)}

   for \eqn{a > 0}, \eqn{b > 0} and \eqn{0 \leq x \leq 1}{0 <= x <= 1} where the
   boundary values at \eqn{x=0} or \eqn{x=1} are defined as by continuity (as limits).

   The mean is \eqn{\frac{a}{a+b}}{a/(a+b)} and the variance is
   \eqn{{ab}{(a+b)^2 (a+b+1)}}{ab/((a+b)^2 (a+b+1))}
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qbeta
 vbeta(3, shape1 = 3, shape2 = 1, ncp = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qbeta
 vbeta(3, 3, 1, stream = 1)
 vbeta(3, 3, 1, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qbeta
 vbeta(1, 3, 1, stream = 1)
 vbeta(1, 3, 1, stream = 2)
 vbeta(1, 3, 1, stream = 1)
 vbeta(1, 3, 1, stream = 2)
 vbeta(1, 3, 1, stream = 1)
 vbeta(1, 3, 1, stream = 2)

 set.seed(8675309)
 variates <- vbeta(1000, 3, 1, stream = 1)
 set.seed(8675309)
 variates <- vbeta(1000, 3, 1, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link{rstream}}, \code{\link{set.seed}},
         \code{\link[=runif]{stats::runif}}

\code{\link[=rbeta]{stats::rbeta}}
}
\author{
Barry Lawson (\email{blawson@richmond.edu}), \cr
   Larry Leemis (\email{leemis@math.wm.edu}), \cr
   Vadim Kudlay (\email{vadim.kudlay@richmond.edu})
}
\concept{random variate generation}
\keyword{distribution}
