% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWaitTimeSum.R
\name{getWaitTimeSum}
\alias{getWaitTimeSum}
\title{Event Times Distributed as Sum of Weibull}
\usage{
getWaitTimeSum(U, haz1, haz2, p1, p2, entry)
}
\arguments{
\item{U}{(\code{numeric})\cr uniformly distributed random variables.}

\item{haz1}{(positive \code{number})\cr  first summand (constant hazard).}

\item{haz2}{(positive \code{number})\cr  second summand (constant hazard).}

\item{p1}{(positive \code{number})\cr rate parameter of Weibull distribution for \code{haz1}.}

\item{p2}{(positive \code{number})\cr rate parameter of Weibull distribution for \code{haz2}.}

\item{entry}{(\code{numeric})\cr the entry times in the current state.}
}
\value{
This returns a vector with event times.
}
\description{
This returns event times with a distribution resulting from the sum of two Weibull distributed random variables
using the inversion method.
}
\examples{
getWaitTimeSum(U = c(0.4, 0.5), haz1 = 0.8, haz2 = 1, p1 = 1.1, p2 = 1.5, entry = c(0, 0))
}
