% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/times.R
\name{simCrackTime}
\alias{simCrackTime}
\title{Defect failure times}
\usage{
simCrackTime(S, stress, vickers, param, cores = getOption("simLife.mc",
  1L))
}
\arguments{
\item{S}{geometry objects system}

\item{stress}{stress level for generation of failure times}

\item{vickers}{Vickers hardness, see details}

\item{param}{list of parameter vectors for simulation of failure times for both phases}

\item{cores}{optional, number of cores for mulicore parallization with \code{cores=1L} (default) by \code{mclapply} which 
also can be set by a global option "\code{simLife.mc}"}
}
\value{
a list with the following elements:
			\itemize{
				\item{id}{ id of particle }
				\item{U}{ crack failure time }
				\item{V}{ delamination failure time }
				\item{T}{ the minimum of both failure times}
				\item{B}{ failure type, either 0  for particle crack or 1 for particle delamination }
				\item{A}{ projection area set to zero for later use }
				\item{label}{ either \code{label="P"} for primary phase or \code{label="F"}
							  for secondary phase }
			}
}
\description{
Simulation of individual defect failure times. For a secondary phase only
the defect type "delamination" is considered.
}
\author{
Felix Ballani, Markus Baaske
}
