% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic_function.R
\name{plotGraphNELD3}
\alias{plotGraphNELD3}
\title{Dynamic plot of a graph}
\usage{
plotGraphNELD3(graph, type = "cor", S1 = NULL, S2 = NULL, colLim = c(-1,
  1), legendColor = TRUE, colNode = "#c0c0c0")
}
\arguments{
\item{graph}{A graphNEL object.}

\item{type}{Character string specifying which matrix is to be used. Either cor for correlation matrix, or pcor for partial correlation matrix.}

\item{S1, S2}{Sample covariance matrix. If \code{S1} is supplied edges between nodes are colored in accordance with pairwise correlation or partial correlation coefficients. If \code{S2} supplied, the difference between the two corresponding correlation or partial correlation matrices is plotted.}

\item{colLim}{Numeric vector of length two specifying the lower and upper bound of the color range (see Details).}

\item{legendColor}{ogical value indicating whether the color legend should be added to the plot.}

\item{colNode}{A character string specifying the colour of the nodes. The colour node is common for all nodes.}
}
\value{
Dynamic plot of a graphNEL object.
}
\description{
Dynamic plot of a graphNEL object with the possibility to emphasize the strength of relations between nodes, represented by either a pairwise correlation or a partial correlation coefficient. \cr \cr
The interactive graph is an implementation of the javascript D3.js package (force-layout) for undirected and directed graphNEL objects (see references).
}
\details{
Admissible values for \code{colLim} are contained in the interval \code{[-1,1]} when \code{S2=NULL}, otherwise the admissible interval is \code{[-2,2]}. When an element is outside of the colLim interval, it is colored gray and represented as a dashed link.
}
\examples{
if(require(gRbase) & require(graph)){
  graph <- gRbase::ug(~a:b, ~a:c, ~c:d, ~b:d, ~b:c)
  # Plot a graphNEL
  plotGraphNELD3(graph)

  # Plot a graphNEL coloring edges in correspondance with pairwise correlation coefficients
  S <- matrix(c(2,  0.8,0.5,-0.3,
                0.8,1.5,0.6,-0.7,
                0.5,0.6,1,  0.7,
                -0.3,-0.7,0.7,3), ncol=4,nrow=4)
  colnames(S) <- rownames(S) <- graph::nodes(graph)
  plotGraphNELD3(graph, S1=S)

  # Plot a graphNEL coloring edges in correspondance with partial correlation coefficients
  plotGraphNELD3(graph, S1=S, type="pcor")

  # Change the color range
  plotGraphNELD3(graph, S1=S, type="cor", colLim=c(-0.7,0.8))
  # Change nodes color
  plotGraphNELD3(graph, S1=S, type="cor", colNode = "pink")

  # Plot the difference between two graphical models
  S2 <- S
  S2[1,3] <- S2[3,1]<- -0.1
  plotGraphNELD3(graph,S1=S, S2=S2)

}
}
\references{
\url{https://d3js.org} (Micheal Bostock).

\url{http://www.htmlwidgets.org} (Ramnath Vaidyanathan, Kenton Russell, and RStudio).

\url{https://christophergandrud.github.io/networkD3/} (Christopher Gandrud, JJ Allaire, & Kent Russell)
}

