% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{prob_lower_site_ae_vs_study_ae}
\alias{prob_lower_site_ae_vs_study_ae}
\title{Calculate bootstrapped probability for obtaining a lower site mean AE number.}
\usage{
prob_lower_site_ae_vs_study_ae(site_ae, study_ae, r = 1000, parallel = FALSE)
}
\arguments{
\item{site_ae}{vector with AE numbers}

\item{study_ae}{vector with AE numbers}

\item{r}{integer, denotes number of simulations, default = 1000}

\item{parallel}{logical, toggles parallel processing on and of, default = F}
}
\value{
pval
}
\description{
Internal function used by \code{\link[=sim_sites]{sim_sites()}}
}
\details{
sets pvalue=1 if mean AE site is greater than mean AE study
}
\examples{
prob_lower_site_ae_vs_study_ae(
  site_ae = c(5, 3, 3, 2, 1, 6),
  study_ae = c(9, 8, 7, 9, 6, 7, 8),
  parallel = FALSE
)
}
\seealso{
\code{\link[purrr]{safely}}
}
