% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{poiss_test_site_ae_vs_study_ae}
\alias{poiss_test_site_ae_vs_study_ae}
\title{Poisson test for vector with site AEs vs vector with study AEs.}
\usage{
poiss_test_site_ae_vs_study_ae(site_ae, study_ae, visit_med75)
}
\arguments{
\item{site_ae}{vector with AE numbers}

\item{study_ae}{vector with AE numbers}

\item{visit_med75}{integer}
}
\value{
pval
}
\description{
Internal function used by \code{\link[=sim_sites]{sim_sites()}}.
}
\details{
sets pvalue=1 if mean AE site is greater than mean AE study or ttest gives error
}
\examples{
poiss_test_site_ae_vs_study_ae(
   site_ae = c(5, 3, 3, 2, 1, 6),
   study_ae = c(9, 8, 7, 9, 6, 7, 8),
   visit_med75 = 10
)

poiss_test_site_ae_vs_study_ae(
   site_ae = c(11, 9, 8, 6, 3),
   study_ae = c(9, 8, 7, 9, 6, 7, 8),
   visit_med75 = 10
)
}
\seealso{
\code{\link[=sim_sites]{sim_sites()}}
}
