% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_simaerep.R
\name{simaerep_inframe}
\alias{simaerep_inframe}
\title{simulate in dataframe}
\usage{
simaerep_inframe(
  df_visit,
  r = 1000,
  under_only = FALSE,
  visit_med75 = FALSE,
  check = TRUE,
  param_site_aggr = list(method = "med75_adj", min_pat_pool = 0.2),
  param_eval_sites = list(method = "BH"),
  env = parent.frame()
)
}
\arguments{
\item{df_visit}{Data frame with columns: study_id, site_number, patnum, visit,
n_ae.}

\item{r}{Integer or tbl_object, number of repetitions for bootstrap
simulation. Pass a tbl object referring to a table with one column and as
many rows as desired repetitions. Default: 1000.}

\item{under_only}{Logical, compute under-reporting probabilities only.
Supersedes under_only parameter passed to \code{\link[=eval_sites]{eval_sites()}} and \code{\link[=sim_sites]{sim_sites()}}.
Default: TRUE.}

\item{visit_med75}{Logical, should evaluation point visit_med75 be used.
Default: TRUE.}

\item{check}{Logical, perform data check and attempt repair with
\code{\link[=check_df_visit]{check_df_visit()}}. Computationally expensive on large data sets. Default:
TRUE.}

\item{param_site_aggr}{List of parameters passed to \code{\link[=site_aggr]{site_aggr()}}. Default:
list(method = "med75_adj", min_pat_pool = 0.2).}

\item{param_eval_sites}{List of parameters passed to \code{\link[=eval_sites]{eval_sites()}}. Default:
list(method = "BH").}

\item{env}{Optional, provide environment of original visit data. Default:
parent.frame().}
}
\description{
simulate in dataframe
}
\examples{
df_visit <- sim_test_data_study(
 n_pat = 100,
 n_sites = 5,
 frac_site_with_ur = 0.4,
 ur_rate = 0.6
)
df_visit$study_id <- "A"

simaerep_inframe(df_visit)
simaerep_inframe(df_visit, visit_med75 = TRUE)$df_eval
\donttest{
# Database
con <- DBI::dbConnect(duckdb::duckdb(), dbdir = ":memory:")
df_r <- tibble::tibble(rep = seq(1, 1000))

dplyr::copy_to(con, df_visit, "visit")
dplyr::copy_to(con, df_r, "r")

tbl_visit <- dplyr::tbl(con, "visit")
tbl_r <- dplyr::tbl(con, "r")

simaerep_inframe(tbl_visit, r = tbl_r)$df_eval
simaerep_inframe(tbl_visit, r = tbl_r, visit_med75 = TRUE)$df_eval

DBI::dbDisconnect(con)
}
}
\keyword{internal}
