% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{attribute_classes}
\alias{attribute_classes}
\title{Simulate all the Latent Attribute Profile \eqn{\mathbf{\alpha}_c} in Matrix form}
\usage{
attribute_classes(K)
}
\arguments{
\item{K}{Number of Attributes}
}
\value{
A \eqn{2^K} by \eqn{K} \code{matrix} of latent classes
corresponding to entry \eqn{c} of \eqn{pi} based upon
mastery and nonmastery of the \eqn{K} skills.
}
\description{
Generate the \eqn{\mathbf{\alpha}_c = (\alpha_{c1}, \ldots, \alpha_{cK})'}
attribute profile matrix for members of class \eqn{c} such that \eqn{\alpha_{ck}}
is 1 if members of class \eqn{c} possess skill \eqn{k} and zero otherwise.
}
\examples{
## Simulate Attribute Class Matrix ----

# Define number of attributes
K = 3

# Generate an Latent Attribute Profile (Alpha) Matrix
alphas = attribute_classes(K)
}
\seealso{
\code{\link[simcdm:sim_subject_attributes]{simcdm::sim_subject_attributes()}} and \code{\link[simcdm:attribute_inv_bijection]{simcdm::attribute_inv_bijection()}}
}
\author{
James Joseph Balamuta and Steven Andrew Culpepper
}
