% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_rrum_items}
\alias{sim_rrum_items}
\title{Generate data from the rRUM}
\usage{
sim_rrum_items(Q, rstar, pistar, alpha)
}
\arguments{
\item{Q}{A \code{matrix} with \eqn{J} rows and \eqn{K} columns indicating
which attributes are required to answer each of the items,
where \eqn{J} represents the number of items and \eqn{K} the
number of attributes.  An entry of 1 indicates attribute
\eqn{k} is required to answer item \eqn{j}.  An entry of one
indicates attribute \eqn{k} is not required.}

\item{rstar}{A \code{matrix} a matrix with \eqn{J} rows and \eqn{K} columns
indicating the penalties for failing to have each of the
required attributes, where \eqn{J} represents the number of
items and \eqn{K} the number of attributes. \code{rstar} and \code{Q}
must share the same 0 entries.}

\item{pistar}{A \code{vector} of length \eqn{J} indicating the probabiliies of
answering each item correctly for individuals who do not lack
any required attribute, where \eqn{J} represents the number
of items.}

\item{alpha}{A \code{matrix} with \eqn{N} rows and \eqn{K} columns indicating
the subjects attribute acquisition, where \eqn{K} represents
the number of attributes.  An entry of 1 indicates individual
\eqn{i} has attained attribute \eqn{k}. An entry of 0
indicates the attribute has not been attained.}
}
\value{
Y     A \code{matrix} with \eqn{N} rows and \eqn{J} columns indicating
the indviduals' responses to each of the items, where \eqn{J}
represents the number of items.
}
\description{
Randomly generate response data according to the reduced Reparameterized
Unified Model (rRUM).
}
\examples{
# Set seed for reproducibility
set.seed(217)

# Define Simulation Parameters
N = 1000 # number of individuals
J = 6 # number of items
K = 2 # number of attributes

# Matrix where rows represent attribute classes
As = attribute_classes(K) 

# Latent Class probabilities
pis = c(.1, .2, .3, .4) 

# Q Matrix
Q = rbind(c(1, 0),
          c(0, 1),
          c(1, 0),
          c(0, 1),
          c(1, 1),
          c(1, 1)
    )
    
# The probabiliies of answering each item correctly for individuals 
# who do not lack any required attribute
pistar = rep(.9, J)

# Penalties for failing to have each of the required attributes
rstar  = .5 * Q

# Randomized alpha profiles
alpha  = As[sample(1:(K ^ 2), N, replace = TRUE, pis),]

# Simulate data
rrum_items = sim_rrum_items(Q, rstar, pistar, alpha)
}
\references{
Culpepper, S. A. & Hudson, A. (In Press). An improved strategy for Bayesian
estimation of the reduced reparameterized unified model. Applied
Psychological Measurement.

Hudson, A., Culpepper, S. A., & Douglas, J. (2016, July). Bayesian estimation
of the generalized NIDA model with Gibbs sampling. Paper presented at the
annual International Meeting of the Psychometric Society, Asheville, North
Carolina.
}
\author{
Steven Andrew Culpepper, Aaron Hudson, and James Joseph Balamuta
}
