% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_processing.R
\name{do_processing}
\alias{do_processing}
\title{Post-processing of datamatrix}
\usage{
do_processing(x, functions = list())
}
\arguments{
\item{x}{Matrix or Data.frame.}

\item{functions}{List of lists, specifying functions to be applied as well as their
arguments. See details.}
}
\value{
Matrix or data.frame with post-processing applied.
}
\description{
Applies functions to a matrix or data.frame.
}
\details{
Functions are passed into the post-processor as a named list. The name
\code{f} of the list entry is the function to be applied via
\code{\link[base:do.call]{base::do.call}}.
The list entry itself is another named list, specifying the arguments
to the function \code{f} as named arguments.

The functions must take a matrix or data.frame as first argument and
return another matrix or data.frame of the same dimensions as
single output.

Examples of post-processing steps are truncation
(\code{\link{process_truncate_by_iqr}},
\code{\link{process_truncate_by_threshold}}) or
centering / standardizing data (via \code{\link{scale}},
see example section below).

Can be useful to apply on simulated datasets, even outside of the
simulation function (e.g. when standardization is only required at the
modeling step).
}
\note{
Use with caution - no error checking is done for now so the user has
to take care of everything themselves! Furthermore, output of the
functions is not checked either.
}
\examples{
do_processing(diag(5), 
    functions = list(scale = list(center = TRUE, scale = FALSE)))

}
