% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{quantile_functions_from_data}
\alias{quantile_functions_from_data}
\alias{quantile_function_from_density}
\alias{quantile_function_from_quantiles}
\title{Helper to estimate quantile functions from data for NORTA}
\usage{
quantile_functions_from_data(
  data,
  method_density = "linear",
  n_density = 200,
  method_quantile = "constant",
  probs_quantile = seq(0, 1, 0.01),
  n_small = 10,
  use_quantile = c(),
  ...
)

quantile_function_from_density(
  x,
  method_density = "linear",
  n_density = 200,
  ...
)

quantile_function_from_quantiles(
  x,
  method_quantile = "constant",
  probs_quantile = seq(0, 1, 0.01)
)
}
\arguments{
\item{data}{A matrix or data.frame for which quantile function should be estimated.}

\item{method_density}{Interpolation method used for density based quantile functions,
passed to \code{\link[stats:approxfun]{stats::approxfun}}. See Details.}

\item{n_density}{Number of points at which the density is estimated for density bsed
quantile, functions, passed to \code{\link[stats:density]{stats::density}}.}

\item{method_quantile}{Interpolation method used for quantile based quantile functions,
passed to \code{\link[stats:approxfun]{stats::approxfun}}. See Details.}

\item{probs_quantile}{Specification of quantiles to be estimated from data for quantile based
quantile functions, passed to \code{\link[stats:quantile]{stats::quantile}}.
See Details.}

\item{n_small}{An integer giving the number of distinct values below which quantile
functions are estimated using \code{quantile_function_from_quantiles()} (more
suited for categorical data), rather than \code{quantile_function_from_density()}.}

\item{use_quantile}{A vector of names indicating columns for which the quantile function
should be estimated using \code{quantile_function_from_quantiles()}. Overrides
\code{n_small}.}

\item{...}{Passed to \code{quantile_function_from_density()}.}

\item{x}{Single vector representing variable input to \code{quantile_function_from_density()}
or \code{quantile_function_from_quantiles()}.}
}
\value{
A named list of functions with length \code{ncol(data)} giving the quantile
functions of the input data. Each entry is a function returned from
\code{\link[stats:approxfun]{stats::approxfun}}.
}
\description{
Helper to estimate quantile functions from data for NORTA
}
\details{
The NORTA approach requires the specification of the marginals by
quantile functions. This helper estimates those given a dataset automatically
and non-parametrically.
There are two ways implemented to estimate quantile functions from data.

\enumerate{
\item Estimate the quantile function by interpolating the observed
quantiles from the data. This is most useful for categorical data, when
the interpolation is using a step-function (default). Implemented in
\code{quantile_function_from_quantiles()}.
\item Estimate the quantile function via the the empirical cumulative
density function derived from the density of the data. Since the density
is only estimated at specific points, any values in between are interpolated
linearly (default, other options are possible). This is most useful for
continuous data. Implemented in \code{quantile_function_from_density()}.
}
}
\seealso{
\code{\link{simdesign_norta}}
}
