% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data_conditional}
\alias{simulate_data_conditional}
\title{Simulate data which satisfies certain conditions}
\usage{
simulate_data_conditional(
  generator,
  n_obs = 1,
  reject = function(x) TRUE,
  reject_max_iter = 10,
  on_reject = "ignore",
  return_tries = FALSE,
  seed = NULL,
  ...
)
}
\arguments{
\item{generator}{Function which generates data from the underlying base distribution. It is
assumend it takes the number of simulated observations \code{n_obs} as first
argument, as all random generation functions in the \pkg{stats} and
\pkg{extraDistr} do. Furthermore, it is expected to return a two-dimensional
array as output (matrix or data.frame). See details.}

\item{n_obs}{Number of simulated observations.}

\item{reject}{Function which takes a matrix or data.frame \code{X} as single input and outputs
TRUE or FALSE. Specifies when a simulated final datamatrix \code{X} should
be rejected. Functions must output TRUE if condition IS NOT met / FALSE if
condition IS met and matrix can be accepted. Intended to be used with
\code{\link{function_list}}. See details.}

\item{reject_max_iter}{Integer > 0. In case of rejection, how many times should a new datamatrix be
simulated until the conditions in \code{reject} are met?}

\item{on_reject}{If "stop", an error is returned if after \code{reject_max_iter} times no
suitable datamatrix X could be found. If "current", the current datamatrix
is returned, regardless of the conditions in \code{reject}.
Otherwise, NULL is returned. In each case a warning is reported.}

\item{return_tries}{If TRUE, then the function also outputs the number of tries necessary to
find a dataset fulfilling the condition. Useful to record to assess
the possible bias of the simulated datasets. See Value.}

\item{seed}{Set random seed to ensure reproducibility of results. See Note below.}

\item{...}{All further parameters are passed to \code{\link{simulate_data}}.}
}
\value{
Data.frame or matrix with \code{n_obs} rows for simulated dataset \code{X} if all
conditions are met within the iteration limit. Otherwise NULL.

If \code{return_tries} is TRUE, then the output is a list with the first entry
being the data.frame or matrix as described above, and the second entry
(\code{n_tries}) giving a numeric with the number of tries necessary to
find the returned dataset.
}
\description{
Generate simulated dataset based on transformation of
an underlying base distribution while checking that certain
conditions are met.
}
\details{
For details on generating, transforming and post-processing datasets, see
\code{\link{simulate_data}}. This function simulates data conditional
on certain requirements that must be met by the final datamatrix \code{X}.
This checking is conducted on the output of \code{simulate_data} (i.e.
also includes possible post-processing steps).
}
\note{
Seeding the random number generator is tricky in this case. The seed can not
be passed to \code{simulate_data} but is set before calling it, otherwise
the random number generation is the same for each of the tries.
This means that the seed used to call this function might not be the seed
corresponding to the returned dataset.
}
\section{Rejecting Datasets}{

Examples for restrictions include
variance restrictions (e.g. no constant columns which could happen due
to extreme transformations of the initial gaussian distribution \code{Z}),
ensuring a sufficient number of observations in a given class (e.g. certain
binary variables should have at least x\\% events) or preventing
multicollinearity (e.g. \code{X} must have full column rank). If \code{reject}
evaluates to FALSE, the current datamatrix \code{X} is rejected.
In case of rejection, new datasets can be simulated until the conditions
are met or a given maximum iteration limit is hit (\code{reject_max_iter}),
after which the latest datamatrix is returned or an error is reported.
}

\section{Rejection Function}{

The \code{reject} function should take a single input (a data.frame or matrix)
and output TRUE if the dataset is to be rejected or FALSE if it is to be
accepted.
This package provides the \code{\link{function_list}} convenience function
which allows to easily create a rejection function which assesses several
conditions on the input dataset by simply passing individual test functions
to \code{function_list}. Such test function templates are found in
\code{\link{is_collinear}} and \code{\link{contains_constant}}.
See the example below.
}

\examples{
dsgn <- simdesign_mvtnorm(diag(5))
simulate_data_conditional(dsgn, 10,
    reject = function_list(is_collinear, contains_constant), 
    seed = 18)

}
\seealso{
\code{\link{simdesign}},
\code{\link{simulate_data}},
\code{\link{function_list}},
\code{\link{is_collinear}},
\code{\link{contains_constant}}
}
