% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Genotype.r
\name{bigt}
\alias{bigt}
\title{Genotype transportor}
\usage{
bigt(pop.geno, ncpus = 0)
}
\arguments{
\item{pop.geno}{genotype matrix of (0, 1).}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}
}
\value{
genotype matrix of (0, 1, 2).
}
\description{
Transport genotype matrix.
}
\details{
Build date: Jan 28, 2025
Last update: Jan 29, 2025
}
\examples{
\donttest{
library(bigmemory)
options(bigmemory.typecast.warning=FALSE)
pop.geno <- matrix(sample(c(0, 1), 16, replace = TRUE), 4, 4)
pop.geno[]
bigmat <- bigt(pop.geno)
bigmat[]
pop.geno <- as.big.matrix(pop.geno, type = 'char')
bigmat <- bigt(pop.geno)
bigmat[]
}
}
\author{
Dong Yin
}
