% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfa_set_cache_dir.R
\name{sfa_set_cache_dir}
\alias{sfa_set_cache_dir}
\title{Set cache directory globally}
\usage{
sfa_set_cache_dir(path, create = FALSE)
}
\arguments{
\item{path}{\link{character} The directory where you want to cache the responses
from the 'SimFin' API calls.}

\item{create}{\link{logical} Set \code{TRUE} if you want to create \code{path} automatically
if it does not yet exist.}
}
\description{
It is highly recommended to set the cache directory globally.
This has two advantages:
\enumerate{
\item Results from the 'SimFin' API calls are cached over the end of the
session. This is especially interesting if you don't have a SimFin+ account
and the number of API calls is limited to 2,000 per day.
\item It makes specifying the \code{cache_dir} argument of other \verb{sfa_*} functions
obsolete.
}
}
