% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfa_load__shares_outstanding.R
\name{sfa_load_weighted_shares_outstanding}
\alias{sfa_load_weighted_shares_outstanding}
\title{Weighted Shares Outstanding}
\usage{
sfa_load_weighted_shares_outstanding(
  id = NULL,
  ticker = NULL,
  fyear = NULL,
  period = NULL,
  start = NULL,
  end = NULL,
  ttm = NULL,
  api_key = getOption("sfa_api_key"),
  cache_dir = getOption("sfa_cache_dir")
)
}
\arguments{
\item{id}{\link{integer} 'SimFin' IDs of the companies of interest. Any
\code{id} will be internally translated to the respective \code{ticker}. This
reduces the number of queries in case you query the same company via
\code{ticker} \emph{and} \code{id}.}

\item{ticker}{\link{integer} Ticker of the companies of interest.}

\item{fyear}{\link{integer} Filter for fiscal year. As a non-SimFin+ user, you
have to provide exactly one fiscal year. As SimFin+ user, this filter can
be omitted to retrieve all data available for the company.}

\item{period}{\link{character} Filter for periods. As a non-SimFin+ user, you have
to provide exactly one period. As SimFin+ user, this filter can be omitted
to retrieve all statements available for the company.
\itemize{
\item \code{'q1'}: First fiscal quarter.
\item \code{'q2'}: Second fiscal quarter.
\item \code{'q3'}: Third fiscal quarter.
\item \code{'q4'}: Fourth fiscal quarter.
\item \code{'fy'}: Full fiscal year.
\item \code{'h1'}: First 6 months of fiscal year.
\item \code{'h2'}: Last 6 months of fiscal year.
\item \code{'9m'}: First nine months of fiscal year.
\item \code{'6m'}: Any fiscal 6 month period (first + second half years; reserved
for SimFin+ users).
\item \code{'quarters'}: All quarters (q1 + q2 + q3 + q4; reserved for SimFin+
users).
}}

\item{start}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending AFTER the specified
date.}

\item{end}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending BEFORE the specified
date.}

\item{ttm}{\link{logical} If \code{TRUE}, retrieves trailing twelve month periods.}

\item{api_key}{\link{character} Your 'SimFin' API key. It's recommended to set
the API key globally using \link{sfa_set_api_key}.}

\item{cache_dir}{\link{character} Your cache directory. It's recommended to set
the cache directory globally using \link{sfa_set_cache_dir}.}
}
\value{
\link{data.table} containing the common shares outstanding.
}
\description{
Get the number of weighted shares outstanding for a company.
}
