% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{clone}
\alias{clone}
\alias{synchronize}
\title{Clone/Synchronize Arrivals}
\usage{
clone(.trj, n, ..., tag)

synchronize(.trj, wait = TRUE, mon_all = FALSE, ..., tag)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{n}{number of clones, accepts either a numeric or a callable object
(a function) which must return a numeric.}

\item{...}{a number of optional parallel sub-trajectories (or a list of
sub-trajectories). Each clone will follow a different sub-trajectory if available.}

\item{tag}{activity tag name to perform named rollbacks (see
\code{\link{rollback}}) or just to better identify your activities.}

\item{wait}{if \code{FALSE}, all clones but the first to arrive are removed.
if \code{TRUE} (default), all clones but the last to arrive are removed.}

\item{mon_all}{if \code{TRUE}, \code{get_mon_arrivals} will show one
line per clone.}
}
\value{
Returns the trajectory object.
}
\description{
Activities for defining a parallel fork and removing the copies. \code{clone}
replicates an arrival \code{n} times (the original one + \code{n-1} copies).
\code{synchronize} removes all but one clone for each set of clones.
}
\examples{
## clone and wait for the others
traj <- trajectory() \%>\%
  clone(
    n = 3,
    trajectory() \%>\%
      log_("clone 0 (original)") \%>\%
      timeout(1),
    trajectory() \%>\%
      log_("clone 1") \%>\%
      timeout(2),
    trajectory() \%>\%
      log_("clone 2") \%>\%
      timeout(3)) \%>\%
  log_("sync reached") \%>\%
  synchronize(wait = TRUE) \%>\%
  log_("leaving")

simmer() \%>\%
  add_generator("arrival", traj, at(0)) \%>\%
  run() \%>\% invisible

## more clones that trajectories available
traj <- trajectory() \%>\%
  clone(
    n = 5,
    trajectory() \%>\%
      log_("clone 0 (original)") \%>\%
      timeout(1)) \%>\%
  log_("sync reached") \%>\%
  synchronize(wait = TRUE) \%>\%
  log_("leaving")

simmer() \%>\%
  add_generator("arrival", traj, at(0)) \%>\%
  run() \%>\% invisible

## clone and continue without waiting
traj <- trajectory() \%>\%
  clone(
    n = 3,
    trajectory() \%>\%
      log_("clone 0 (original)") \%>\%
      timeout(1),
    trajectory() \%>\%
      log_("clone 1") \%>\%
      timeout(2),
    trajectory() \%>\%
      log_("clone 2") \%>\%
      timeout(3)) \%>\%
  log_("sync reached") \%>\%
  synchronize(wait = FALSE) \%>\%
  log_("leaving")

simmer() \%>\%
  add_generator("arrival", traj, at(0)) \%>\%
  run() \%>\% invisible

}
