% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_tooltip.R
\name{add_tooltip}
\alias{add_tooltip}
\title{Add a tooltip column}
\usage{
add_tooltip(data, ..., titles = snakecase::to_sentence_case, name = "tooltip")
}
\arguments{
\item{data}{A data frame or tibble.}

\item{...}{Arguments passed to select (i.e unquoted variables, tidyselect helpers etc). If no arguments provided, uses all columns.}

\item{titles}{A function to format the variable names, including in rlang lambda format.}

\item{name}{The name of the column created. Defaults to "tooltip".}
}
\value{
A data frame or tibble with a column of text
}
\description{
Add a tooltip column of united variable names and values.
}
\examples{
library(ggplot2)

iris \%>\%
  add_tooltip() \%>\%
  head(1)

 iris \%>\%
  add_tooltip(tidyselect::contains("Sepal"), Species) \%>\%
  head(1)

p <- iris \%>\%
  dplyr::mutate(Species = stringr::str_to_sentence(Species)) |>
  add_tooltip(tidyselect::contains("Sepal"), Species) |>
  ggplot() +
  geom_point(aes(x = Sepal.Width, y = Sepal.Length, col = Species, text = tooltip))

p

if (requireNamespace("plotly", quietly = TRUE)) {
  plotly::ggplotly(p, tooltip = "text")
}
}
