% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCluster.R
\name{genCluster}
\alias{genCluster}
\title{Simulate data set that is one level down in a multilevel data context. The
level "2" data set must contain a field that specifies the number of
individual records in a particular cluster.}
\usage{
genCluster(dtClust, cLevelVar, numIndsVar, level1ID, allLevel2 = TRUE)
}
\arguments{
\item{dtClust}{Name of existing data set that contains the level "2" data}

\item{cLevelVar}{Variable name (string) of cluster id in dtClust}

\item{numIndsVar}{Variable name (string) of number of observations
per cluster in dtClust}

\item{level1ID}{Name of id field in new level "1" data set}

\item{allLevel2}{Indicator: if set to TRUE (default), the returned data set
includes all of the Level 2 data columns. If FALSE, the returned data set
only includes the Levels 1 and 2 ids.}
}
\value{
A simulated data table with level "1" data
}
\description{
Simulate data set that is one level down in a multilevel data context. The
level "2" data set must contain a field that specifies the number of
individual records in a particular cluster.
}

