% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genMarkov.R
\name{genMarkov}
\alias{genMarkov}
\title{Generate Markov chain}
\usage{
genMarkov(n, transMat, chainLen, wide = FALSE, id = "id",
  pername = "period", varname = "state", widePrefix = "S",
  trimvalue = NULL)
}
\arguments{
\item{n}{number of individual chains to generate}

\item{transMat}{Square transition matrix where the sum of each row
must equal 1. The dimensions of the matrix equal the number of possible
states.}

\item{chainLen}{Length of each chain that will be generated for each
chain; minimum chain length is 2.}

\item{wide}{Logical variable (TRUE or FALSE) indicating whether the
resulting data table should be returned in wide or long format. The
wide format includes all elements of a chain on a single row; the long
format includes each element of a chain in its own row. The default is
wide = FALSE, so the long format is returned by default.}

\item{id}{Character string that represents name of "id" field. 
Defaults to "id".}

\item{pername}{Character string that represents the variable name of the
chain sequence in the long format. Defaults "period",}

\item{varname}{Character string that represents the variable name of the
state in the long format. Defaults to "state".}

\item{widePrefix}{Character string that represents the variable name 
prefix for the state fields in the wide format. Defaults to "S".}

\item{trimvalue}{Integer value indicating end state. If trimvalue is not NULL, 
all records after the first instance of state = trimvalue will be deleted.}
}
\value{
A data table with n rows if in wide format, or n by chainLen rows 
if in long format.
}
\description{
Generate a Markov chain for n individuals or units by
specifying a transition matrix.
}
\examples{

# Transition matrix P

P <- t(matrix(c( 0.7, 0.2, 0.1,
                 0.5, 0.3, 0.2,
                 0.0, 0.1, 0.9), nrow=3, ncol=3))
                
d1 <- genMarkov(n = 10, transMat = P, chainLen = 5)
d2 <- genMarkov(n = 10, transMat = P, chainLen = 5, wide = TRUE)
d3 <- genMarkov(n = 10, transMat = P, chainLen = 5, 
                pername = "seq", varname = "health", 
                trimvalue = 3)

}
