#' Mean Monthly Precipitation, from 1907 to 1972
#'
#' Hydrology data that indicates a robust approach may be preferred to a
#' classical approach when estimating time series.
#'
#' @format A time series object with frequency 12 starting at 1907 and going to 1972
#' for a total of 781 observations.
#'
#' @source \url{https://datamarket.com/data/set/22w1/mean-monthly-precipitation-1907-1972}
"hydro"


#' Personal Saving Rate
#'
#' Personal saving as a percentage of disposable personal
#' income (DPI), frequently referred to as "the personal saving rate,"
#' is calculated as the ratio of personal saving to DPI.
#'
#' @format A gts time series object with frequency 12 starting at 1959 and going
#' to 2016 for a total of 691 observations.
#' 
#' @source \url{https://fred.stlouisfed.org/series/PSAVERT}
"savingrt"


#' Quarterly Increase in Stocks Non-Farm Total, Australia
#' 
#' A dataset containing the quarterly increase in stocks non-farm total in Australia, with frequency 4 
#' starting from September 1959 to March 1991 with a total of 127 observations.
#' 
#' @format A data frame with 127 rows and 2 variables:
#' \describe{
#'   \item{Quarter}{year and quarter}
#'   \item{Increase}{quarterly increase in stocks non-farm total}
#' }
#' 
#' @source Time Series Data Library (citing: Australian Bureau of Statistics) 
#' \url{https://datamarket.com/data/set/22t0/quarterly-increase-in-stocks-non-farm-total-australia-sep-1959-march-1991#!ds=22t0&display=line}
"australia"

#' Sales Dataset 
#' 
#' This dataset contains the US monthly clothing retail sales in millions of dollars taken from 
#' 1992 to 2016 for a total of 302 observations.
#' 
#' @format A dataframe with 302 rows and 1 variable: 
#' 
#' @source \url{http://r-exercises.com/wp-content/uploads/2017/04/sales.csv}
"sales"

#' @details The data sets in this package may change at a moments notice.
"_PACKAGE"