% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dr_to_wv}
\alias{dr_to_wv}
\title{Drift to WV}
\usage{
dr_to_wv(omega, tau)
}
\arguments{
\item{omega}{A \code{double} corresponding to the slope of the drift}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{vec} containing the wavelet variance of the drift.
}
\description{
This function compute the WV (haar) of a Drift process
}
\section{Process Haar Wavelet Variance Formula}{

The Drift (DR) process has a Haar Wavelet Variance given by:
\deqn{ \nu _j^2\left( {{\omega }} \right) = \frac{{\tau _j^2{\omega ^2}}}{{16}}  }{nu[j]^2 (omega) = (tau[j]^2 * omega^2)/16}
}

