% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-class.R
\docType{class}
\name{Method-class}
\alias{Method-class}
\title{An S4 class representing a method to be run by simulator.}
\description{
An object of class \code{Method} consists of a name, label, and a function
\code{method} that takes arguments model and draw. A draw refers
to a single element of the list in an object of class \code{\linkS4class{Draws}}.
}
\details{
This class inherits from the \code{\linkS4class{Component}} class.
}
\section{Slots}{

\describe{
\item{\code{name}}{a short name identifier.  Must be alphanumeric.}

\item{\code{label}}{a longer, human readable label that can have other characters
such as spaces, hyphens, etc.}

\item{\code{settings}}{(optional) a list of "settings" for the method (e.g., tuning
parameters or related information that might distinguish two otherwise
identical methods).}

\item{\code{method}}{a function that has arguments "model", "draw"
and (optionally) names matching elements within \code{names(settings)}}
}}

