% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissoc_power.R
\name{UDT_power}
\alias{UDT_power}
\title{Power calculator for UDT}
\usage{
UDT_power(
  case_a,
  case_b,
  mean_a = 0,
  mean_b = 0,
  sd_a = 1,
  sd_b = 1,
  r_ab = 0.5,
  sample_size = NULL,
  power = NULL,
  alternative = c("two.sided", "greater", "less"),
  alpha = 0.05,
  spec = 0.005
)
}
\arguments{
\item{case_a}{A single value from the expected case observation on task A.}

\item{case_b}{A single value from the expected case observation on task B.}

\item{mean_a}{The expected mean from the control sample on task A. Defaults
to 0.}

\item{mean_b}{The expected mean from the control sample on task B. Defaults
to 0.}

\item{sd_a}{The expected standard deviation from the control sample on task
A. Defaults to 1.}

\item{sd_b}{The expected standard deviation from the control sample on task
B. Defaults to 1.}

\item{r_ab}{The expected correlation between the tasks. Defaults to 0.5}

\item{sample_size}{The size of the control sample, vary this parameter to see
how the sample size affects power. One of sample size or power must be
specified, not both.}

\item{power}{A single value between 0 and 1 specifying desired power for
calculating necessary sample size. One of sample size or power must be
specified, not both.}

\item{alternative}{The alternative hypothesis. A string of either "two.sided"
(default) or "one.sided".}

\item{alpha}{The specified Type I error rate. This can also be varied, with
effects on power. Defaults to 0.05.}

\item{spec}{A single value between 0 and 1. If desired power is given as
input the function will utilise a search algorithm to find the sample size
needed to reach the desired power. However, if the power specified is
greater than what is actually possible to achieve the algorithm could
search forever. Hence, when power does not increase substantially for any
additional participant in the sample, the algorithm stops. By default the
algorithm stops when power does not increase more than 0.5% for any added
participant, but by varying \code{spec}, this specificity can be changed.}
}
\value{
Either a single value of the exact power, if sample size is given. Or
  a dataframe consisting of both the sample size and the exact power such
  size would yield.
}
\description{
Calculates exact power given sample size or sample size given power, using
analytical methods for the frequentist test of deficit for a specified case
scores, means and standard deviations for the control sample. The means and
standard deviations defaults to 0 and 1 respectively, so if no other values
are given, the case scores are interpreted as deviations from the mean in
standard deviations. The returned value will approximate the power for the
given parameters.
}
\examples{
UDT_power(case_a = -3, case_b = -1, mean_a = 0, mean_b = 0,
          sd_a = 1, sd_b = 1, r_ab = 0.5, sample_size = 20)
UDT_power(case_a = -3, case_b = -1, power = 0.8)
}
