% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSDT.R
\name{RSDT}
\alias{RSDT}
\title{Revised Standardised Difference Test}
\usage{
RSDT(
  case_a,
  case_b,
  controls_a,
  controls_b,
  sd_a = NULL,
  sd_b = NULL,
  sample_size = NULL,
  r_ab = NULL,
  alternative = c("two.sided", "greater", "less"),
  na.rm = FALSE
)
}
\arguments{
\item{case_a}{Case's score on task A.}

\item{case_b}{Case's score on task B.}

\item{controls_a}{Controls' scores on task A. Takes either a vector of
observations or a single value interpreted as mean. \emph{Note}: you can
supply a vector as input for task A while mean and SD for task B.}

\item{controls_b}{Controls' scores on task B. Takes either a vector of
observations or a single value interpreted as mean. \emph{Note}: you can
supply a vector as input for task B while mean and SD for task A.}

\item{sd_a}{If single value for task A is given as input you must
supply the standard deviation of the sample.}

\item{sd_b}{If single value for task B is given as input you must
supply the standard deviation of the sample.}

\item{sample_size}{If A or B is given as mean and SD you must supply the
sample size. If controls_a is given as vector and controls_b as mean and
SD, sample_size must equal the number of observations in controls_a.}

\item{r_ab}{If A or B is given as mean and SD you must supply the
correlation between the tasks.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}. You can specify just the initial letter. Since the direction
of the expected effect depends on which task is set as A and which is set
as B, be very careful if changing this parameter.}

\item{na.rm}{Remove \code{NA}s from controls.}
}
\value{
A list with class \code{"htest"} containing the following components:
  \tabular{llll}{ \code{statistic}   \tab Returns the value of a approximate
  t-statistic, however, because of the underlying equation, it cannot be
  negative. See effect direction from Z-DCC. \cr\cr \code{parameter} \tab the
  degrees of freedom for the t-statistic.\cr\cr \code{p.value}    \tab the
  p-value for the test.\cr\cr \code{estimate} \tab case scores expressed as
  z-scores on task A and Y. Standardised effect size (Z-DCC) of task
  difference between case and controls and point estimate of the proportion
  of the control population estimated to show a more extreme task
  discrepancy. \cr\cr \code{sample.size}   \tab the size of the control
  sample\cr\cr \code{null.value}   \tab the value of the discrepancy under
  the null hypothesis.\cr\cr  \code{alternative}     \tab a character string
  describing the alternative hypothesis.\cr\cr \code{method} \tab a character
  string indicating what type of test was performed.\cr\cr \code{data.name}
  \tab a character string giving the name(s) of the data}
}
\description{
A test on the discrepancy between two tasks in a single case, by comparison
to the discrepancy of means in the same two tasks in a control sample.
Standardises task scores as well as task discrepancy, so the tasks do not
need to be measured on the same scale. Calculates a standardised effect size
(Z-DCC) of task discrepancy as well as a point estimate of the proportion of
the control population that would be expected to show a more extreme
discrepancy. Developed by Crawford and Garthwaite (2005).
}
\examples{
RSDT(-3.857, -1.875, controls_a = 0, controls_b = 0, sd_a = 1,
sd_b = 1, sample_size = 20, r_ab = 0.68)

RSDT(case_a = size_weight_illusion[1, "V_SWI"], case_b = size_weight_illusion[1, "K_SWI"],
 controls_a = size_weight_illusion[-1, "V_SWI"], controls_b = size_weight_illusion[-1, "K_SWI"])

}
\references{
Crawford, J. R., & Garthwaite, P. H. (2005). Testing for
Suspected Impairments and Dissociations in Single-Case Studies in
Neuropsychology: Evaluation of Alternatives Using Monte Carlo Simulations and
Revised Tests for Dissociations. \emph{Neuropsychology, 19}(3), 318 - 331.
\doi{10.1037/0894-4105.19.3.318}
}
