% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_continuous.R
\name{get_log_p_D_KL_continuous}
\alias{get_log_p_D_KL_continuous}
\title{Estimates the significance of the observed Kullback-Leibler divergence by comparing to randomizations for the continuous version of haystack.}
\usage{
get_log_p_D_KL_continuous(
  D_KL.observed,
  D_KL.randomized,
  all.coeffVar,
  train.coeffVar,
  output.dir = NULL,
  spline.method = "ns"
)
}
\arguments{
\item{D_KL.observed}{A vector of observed Kullback-Leibler divergences.}

\item{D_KL.randomized}{A matrix of Kullback-Leibler divergences of randomized datasets.}

\item{all.coeffVar}{Coefficients of variation of all genes. Used for fitting the Kullback-Leibler divergences.}

\item{train.coeffVar}{Coefficients of variation of genes that will be used for fitting the Kullback-Leibler divergences.}

\item{output.dir}{Optional parameter. Default is NULL. If not NULL, some files will be written to this directory.}

\item{spline.method}{Method to use for fitting splines "ns" (default): natural splines, "bs": B-splines.}
}
\value{
A vector of log10 p values, not corrected for multiple testing using the Bonferroni correction.
}
\description{
Estimates the significance of the observed Kullback-Leibler divergence by comparing to randomizations for the continuous version of haystack.
}
