% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R, R/documentationFiles.R
\name{dfpopsize}
\alias{dfpopsize}
\alias{hatvalues.singleR}
\alias{dfbeta.singleR}
\alias{residuals.singleR}
\alias{cooks.distance.singleR}
\alias{dfpopsize.singleR}
\alias{regDiagSingleR}
\title{Regression diagnostics in \code{singleRcapture}}
\usage{
dfpopsize(model, ...)

\method{hatvalues}{singleR}(model, ...)

\method{dfbeta}{singleR}(model, maxitNew = 1, ...)

\method{residuals}{singleR}(
  object,
  type = c("pearson", "pearsonSTD", "response", "working", "deviance", "all"),
  ...
)

\method{cooks.distance}{singleR}(model, ...)

\method{dfpopsize}{singleR}(model, dfbeta = NULL, observedPop = FALSE, ...)
}
\arguments{
\item{model, object}{object of \code{singleR} class.}

\item{...}{arguments passed to other methods.
Notably \code{dfpopsize.singleR} calls \code{dfbeta.singleR} if no
\code{dfbeta} argument was provided and \code{controlMethod} is called in
\code{dfbeta} method.}

\item{maxitNew}{maximal number of iterations for regressions with starting
points \mjseqn{\hat{\boldsymbol{\beta}}} on data
specified at call for \code{model} after the removal of k'th row. By default 1.}

\item{type}{a type of residual to return.}

\item{dfbeta}{if \code{dfbeta} was already obtained it is possible to pass
them into function so that they need not be computed for the second time.}

\item{observedPop}{logical. For \code{singleR} class object if set to
\code{TRUE} indicates that 1 will be returned for units which do not
take part in population size estimation (e.g. 1's in zero one truncated
models or units with count => 3 for \code{zelterman} of basic \code{chao}
model) if set to \code{FALSE} (default) these units will not be included
in results.}
}
\value{
\itemize{
\item For \code{hatvalues} -- A matrix with n rows and p columns where n is a
number of observations in the data and p is number of regression parameters.
\item For \code{dfpopsize} -- A vector for which k'th element corresponds
to the difference between point estimate of population size estimation on
full data set and point estimate of population size estimation after the
removal of k'th unit from the data set.
\item For \code{dfbeta} -- A matrix with n rows and p observations where p
is a number of units in data and p is the number of regression parameters.
K'th row of this matrix corresponds to
\mjseqn{\hat{\boldsymbol{\beta}}-\hat{\boldsymbol{\beta}}_{-k}}
where \mjseqn{\hat{\boldsymbol{\beta}}_{-k}} is a vector of estimates for
regression parameters after the removal of k'th row from the data.
\item \code{cooks.distance} -- A matrix with a single columns with
values of cooks distance for every unit in \code{model.matrix}
\item \code{residuals.singleR} -- A \code{data.frame} with chosen residuals.
}
}
\description{
List of some regression diagnostics implemented for
\code{singleR} class. Functions that either require no changes from
\code{glm} class or are not relevant to context of \code{singleRcapture}
are omitted.
}
\details{
\loadmathjax

\code{dfpopsize} and \code{dfbeta} are closely related. \code{dfbeta}
fits a regression after removing a specific row from the data and returns the
difference between regression coefficients estimated on full data set and
data set obtained after deletion of that row, and repeats procedure once
for every unit present in the data.\code{dfpopsize} does the same for
population size estimation utilising coefficients computed by \code{dfbeta}.

\code{cooks.distance} is implemented (for now) only for models with a single
linear predictor and works exactly like the method for \code{glm} class.

\code{residuals.singleR} (can be abbreviated to \code{resid}) works like
\code{residuals.glm} with the exception that:
\itemize{
\item \code{"pearson"} -- returns non standardised residuals.
\item \code{"pearsonSTD"} -- is currently defined only for single predictors
models but will be extended to all models in a near future, but for families
with more than one distribution parameter it will be a multivariate residual.
\item \code{"response"} -- returns both residuals computed with truncated
and non truncated fitted value.
\item \code{"working"} -- is possibly multivariate if more than one linear
predictor is present.
\item \code{"deviance"} -- is not yet defined for all families in
\code{\link[=singleRmodels]{singleRmodels()}} e.g. negative binomial based methods.
\item \code{"all"} -- returns all available residual types.
}

\code{hatvalues.singleR} is method for \code{singleR} class for extracting
diagonal elements of projection matrix.

Since \code{singleRcapture} supports
not only regular glm's but also vglm's the \code{hatvalues} returns a matrix
with number of columns corresponding to number of linear predictors in a model,
where kth column corresponds to elements of the diagonal of projection
matrix associated with kth linear predictor. For glm's
\mjsdeqn{\boldsymbol{W}^{\frac{1}{2}}\boldsymbol{X}
\left(\boldsymbol{X}^{T}\boldsymbol{W}\boldsymbol{X}\right)^{-1}
\boldsymbol{X}^{T}\boldsymbol{W}^{\frac{1}{2}}}
where: \mjseqn{\boldsymbol{W}=\mathbb{E}\left(\text{Diag}
\left(\frac{\partial^{2}\ell}{\partial\boldsymbol{\eta}^{T}
\partial\boldsymbol{\eta}}\right)\right)}
and \mjseqn{\boldsymbol{X}} is a model (lm) matrix.
For vglm's present in the package it is instead :
\mjsdeqn{\boldsymbol{X}_{vlm}
\left(\boldsymbol{X}_{vlm}^{T}\boldsymbol{W}\boldsymbol{X}_{vlm}\right)^{-1}
\boldsymbol{X}_{vlm}^{T}\boldsymbol{W}}
where:
\mjsdeqn{
\boldsymbol{W} = \mathbb{E}\left(\begin{bmatrix}
\text{Diag}\left(\frac{\partial^{2}\ell}{\partial\eta_{1}^{T}\partial\eta_{1}}\right) &
\text{Diag}\left(\frac{\partial^{2}\ell}{\partial\eta_{1}^{T}\partial\eta_{2}}\right) &
\dotso & \text{Diag}\left(\frac{\partial^{2}\ell}{\partial\eta_{1}^{T}\partial\eta_{p}}\right)\cr
\text{Diag}\left(\frac{\partial^{2}\ell}{\partial\eta_{2}^{T}\partial\eta_{1}}\right) &
\text{Diag}\left(\frac{\partial^{2}\ell}{\partial\eta_{2}^{T}\partial\eta_{2}}\right) &
\dotso & \text{Diag}\left(\frac{\partial^{2}\ell}{\partial\eta_{2}^{T}\partial\eta_{p}}\right)\cr
\vdots & \vdots & \ddots & \vdots\cr
\text{Diag}\left(\frac{\partial^{2}\ell}{\partial\eta_{p}^{T}\partial\eta_{1}}\right) &
\text{Diag}\left(\frac{\partial^{2}\ell}{\partial\eta_{p}^{T}\partial\eta_{2}}\right) &
\dotso & \text{Diag}\left(\frac{\partial^{2}\ell}{\partial\eta_{p}^{T}\partial\eta_{p}}\right)
\end{bmatrix}\right)}
is a block matrix constructed by taking the expected  value from diagonal
matrixes corresponding to second derivatives with respect to each linear
predictor (and mixed derivatives) and
\mjseqn{\boldsymbol{X}_{vlm}} is a model (vlm)
matrix constructed using specifications in \code{controlModel} and
call to \code{estimatePopsize}.
}
\examples{
\donttest{
# For singleR class
# Get simple model
Model <- estimatePopsize(
  formula = capture ~ nation + age + gender, 
  data = netherlandsimmigrant, 
  model = ztpoisson, 
  method = "IRLS"
)
# Get df beta
dfb <- dfbeta(Model)
# The results
res <- dfpopsize(Model, dfbeta = dfb)
summary(res)
plot(res)
# It is also possible to not provide dfbeta then they will be
# computed manually
summary(dfpopsize(Model))
}
}
\seealso{
\code{\link[=estimatePopsize]{estimatePopsize()}} \code{\link[stats:influence.measures]{stats::hatvalues()}} \code{\link[=controlMethod]{controlMethod()}} \code{\link[stats:influence.measures]{stats::dfbeta()}}
\code{\link[stats:influence.measures]{stats::cooks.distance()}}
}
\author{
Piotr Chlebicki, Maciej Beręsewicz
}
