\name{psymas}
\alias{psymas}
\docType{data}
\title{
psymas database
}
\description{
A database to be used as example in the functions included on \code{siren} package. It contains the answers of 1309 participants to the Psychological Maturity Assessment Scale (Morales-Vives et al., 2012, 2013). The example database provided only contains 10 items and measures two subscales.
}
\usage{data("psymas")}
\format{
A data frame with 1309 observations and 10 variables.
}
\details{
This questionnaire estimates the psychological maturity of adolescents, understood as the ability to take responsibility for one's own obligations, taking into account one's own characteristics and needs, without showing excessive dependence on others. More specifically, we have used twelve items from two of the subscales of this questionnaire (four items of Self-reliance subscale and six items of Identity subscale) so that within each subscale half of the items were in one direction (lack of maturity) and the other half in the opposite direction (high maturity). Self-reliance refers to willingness to take the initiative without allowing others to exercise excessive control, and Identity refers to knowledge about own’s characteristics and needs. The study carried out by Morales-Vives et al. (2013) shows that these factors are correlated, and that some of the items are affected by the acquiescence response bias.
}
\references{
Morales-Vives, F., Camps, E., & Lorenzo-Seva, U. (2012). Manual del Cuestionario de Madurez Psicológica PSYMAS. TEA Ediciones, S.A.
Morales-Vives, F., Camps, E., & Lorenzo-Seva, U. (2013). Development and validation of the psychological maturity assessment scale (PSYMAS). European Journal of Psychological Assessment. \doi{10.1027/1015-5759/a000115}
}
\examples{
data(psymas)
}
\keyword{datasets}
