


############################################################################################################
# Summarizing testlet effect using Q3 statistic     
##NS export(testlet.yen.q3)                                                        
Q3.testlet <- function( q3.res , testlet.matrix ){
        # INPUT:
        # q3.res    ... object generated by yen.q3
        # testlet.matrix    ... matrix -> column 1: testlet label, column 2: item label
        N.item.testlet <- stats::aggregate( base::rep(1, base::nrow(testlet.matrix) ) , 
		                      base::list( testlet.matrix[,1]) , base::sum )
        testlet.matrix <- testlet.matrix[ testlet.matrix[,1] %in% 
		                        N.item.testlet[ N.item.testlet[,2] > 1 , 1 ] , ]
        testlets <- base::sort( base::unique( testlet.matrix[,1] ) )
        testlet.q3 <- base::t( base::sapply( testlets , FUN = function(testlet){
            testlet.items <- testlet.matrix[ testlet.matrix[,1] == testlet , 2 ]
            ti.ind <- colnames(q3.res$q3.matrix) %in% testlet.items			
            # c( sum( ti.ind) , mean( q3.res$q3.matrix[ ti.ind , ti.ind ] , na.rm=T ) )
			# correction thanks to Thomas Kiefer (2014-03-06)
			base::c( base::sum( ti.ind) , base::mean( 
			         q3.res$q3.matrix[ ti.ind , ti.ind ][ 
							base::lower.tri( base::diag( base::sum(ti.ind))) ] ,
					 na.rm=TRUE ) )			
                } ) )
        base::colnames(testlet.q3) <- base::c("N.Items" , "Mean.Q3" )
        testlet.q3 <- data.frame( "Testlet" = testlets , testlet.q3 , 
							"mean" = base::mean(q3.res$q3.long[,3]) )
        base::rownames(testlet.q3) <- NULL
        # mean Q3-statistics between testlets
        TT <- base::length(testlets)
        matr <- base::matrix( 1 , nrow= TT , ncol=TT )
        colnames(matr) <- rownames(matr) <- testlets
        for (ii1 in base::seq(1,TT-1)){
            for (ii2 in base::seq(ii1+1 , TT )){
            tt1 <- base::paste(testlets[ii1])
            tt2 <- base::paste(testlets[ii2])
            itt1 <- testlet.matrix[ testlet.matrix[ ,1] == tt1 ,2 ]
            itt2 <- testlet.matrix[ testlet.matrix[ ,1] == tt2 ,2 ]    
            q.tt <- q3.res$q3.matrix[ base::paste( itt1 ) , base::paste( itt2) ] 
            matr[ tt1 , tt2 ] <- matr[tt2,tt1] <- base::mean( q.tt , na.rm=TRUE )
            } 
        }
		base::diag(matr) <- testlet.q3$Mean.Q3
        base::cat( "\nMean Q3 Testlets:" , base::round( base::mean(testlet.q3$Mean.Q3) , 5 ),"\n\n")
        base::print( testlet.q3 , digits = 3 )
        base::cat( "\n\nMean Q3 between testlets \n\n")
		matr1 <- base::round( matr , 3 )
        base::print( matr1 , digits = 3 )
        res <- base::list( "testlet.q3" = testlet.q3 , "testlet.q3.korr" = matr )
        base::return(res)
}
#############################################################################################################

# Q3.testlet <- testlet.yen.q3
