% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_accuracy.R
\name{.sits_accuracy_area_assess}
\alias{.sits_accuracy_area_assess}
\title{Support for Area-weighted post-classification accuracy}
\usage{
.sits_accuracy_area_assess(cube, error_matrix, area)
}
\arguments{
\item{cube}{Data cube.}

\item{error_matrix}{Matrix given in sample counts.
Columns represent the reference data and
rows the results of the classification}

\item{area}{Named vector of the total area of each class on
the map}
}
\value{
A list of lists: The error_matrix, the class_areas, the unbiased
estimated areas, the standard error areas, confidence interval 95% areas,
and the accuracy (user, producer, and overall).
}
\description{
Support for Area-weighted post-classification accuracy
}
\references{
Olofsson, P., Foody G.M., Herold M., Stehman, S.V.,
Woodcock, C.E., Wulder, M.A. (2014)
Good practices for estimating area and assessing accuracy of land change.
Remote Sensing of Environment, 148, pp. 42-57.
}
\author{
Alber Sanchez, \email{alber.ipia@inpe.br}
}
\keyword{internal}
