% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_torch_temporal_attention_encoder.R
\name{.torch_multi_head_attention}
\alias{.torch_multi_head_attention}
\title{Torch module for calculating multi-head attention}
\usage{
.torch_multi_head_attention(n_heads, d_k, d_in)
}
\arguments{
\item{n_heads}{Number of attention heads.}

\item{d_k}{Dimension of key tensor.}

\item{d_in}{Dimension of input values.}
}
\value{
An output encoder tensor.
}
\description{
In order to calculate attentions with a query,
this function takes the dot product of query with the keys
and gets scores/weights for the values.
Each score/weight the relevance between the query and each key.
And you reweight the values with the scores/weights,
and take the summation of the reweighted values.

This implementation is based on the code made available by Vivien Garnot
https://github.com/VSainteuf/lightweight-temporal-attention-pytorch
}
\references{
Vivien Sainte Fare Garnot and Loic Landrieu,
"Lightweight Temporal Self-Attention for Classifying Satellite Image
Time Series", https://arxiv.org/abs/2007.00586
}
\author{
Charlotte Pelletier, \email{charlotte.pelletier@univ-ubs.fr}

Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Souza, \email{lipecaso@gmail.com}
}
\keyword{internal}
