% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_tuning.R
\name{sits_tuning_hparams}
\alias{sits_tuning_hparams}
\title{Tuning machine learning models hyper-parameters}
\usage{
sits_tuning_hparams(...)
}
\arguments{
\item{...}{Used to prepare hyper-parameter space}
}
\value{
A list containing the hyper-parameter space to be passed to
  \code{sits_tuning()}'s \code{params} parameter.
}
\description{
This function allow user building the hyper-parameters space used
by \code{sits_tuning()} function search randomly the best parameter
combination.

User should pass the possible values for hyper-parameters as
constant or by calling the following random functions:

\itemize{
  \item \code{uniform(min = 0, max = 1, n = 1)}: returns random numbers
  from a uniform distribution with parameters min and max.
  \item \code{choice(..., replace = TRUE, n = 1)}: returns random objects
  passed to \code{...} with replacement or not (parameter \code{replace}).
  \item \code{randint(min, max, n = 1)}: returns random integers
  from a uniform distribution with parameters min and max.
  \item \code{normal(mean = 0, sd = 1, n = 1)}: returns random numbers
  from a normal distribution with parameters min and max.
  \item \code{lognormal(meanlog = 0, sdlog = 1, n = 1)}: returns random
  numbers from a lognormal distribution with parameters min and max.
  \item \code{loguniform(minlog = 0, maxlog = 1, n = 1)}: returns random
  numbers from a loguniform distribution with parameters min and max.
  \item \code{beta(shape1, shape2, n = 1)}: returns random numbers
  from a beta distribution with parameters min and max.
}

These functions accepts \code{n} parameter to indicate how many values
should be returned.
}
\examples{
if (sits_run_examples()) {
    # find best learning rate parameters for TempCNN
    tuned <- sits_tuning(
        samples_modis_4bands,
        ml_method = sits_tempcnn(),
        params = sits_tuning_hparams(
            optimizer = choice(
                torchopt::optim_adamw,
                torchopt::optim_yogi
            ),
            opt_hparams = list(
                lr = beta(0.3, 5)
            )
        ),
        trials = 4,
        multicores = 2,
        progress = FALSE
    )
}

}
