% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_classify_cube.R
\name{.sits_classify_multicores}
\alias{.sits_classify_multicores}
\title{Classify a chunk of raster data  using multicores}
\usage{
.sits_classify_multicores(
  tile,
  ml_model,
  roi,
  filter_fn,
  impute_fn,
  memsize,
  multicores,
  output_dir,
  version,
  verbose,
  progress
)
}
\arguments{
\item{tile}{Single tile of a data cube.}

\item{ml_model}{Model trained by \code{\link[sits]{sits_train}}.}

\item{roi}{Region of interest.}

\item{filter_fn}{Smoothing filter function to be applied to the data.}

\item{impute_fn}{Impute function to replace NA.}

\item{memsize}{Memory available for classification (in GB).}

\item{multicores}{Number of cores.}

\item{output_dir}{Output directory.}

\item{version}{Version of result.}

\item{verbose}{print processing information?}

\item{progress}{Show progress bar?}
}
\value{
List of the classified raster layers.
}
\description{
Classifies a block of data using multicores. It breaks
the data into horizontal blocks and divides them between the available cores.

Reads data using terra, cleans the data for NAs and missing values.
The clean data is stored in a data table with the time instances
for all pixels of the block. The algorithm then classifies data on
an year by year basis. For each year, extracts the sub-blocks for each band.

After all cores process their blocks, it joins the result and then writes it
in the classified images for each corresponding year.
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
\keyword{internal}
