% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_filters.R
\name{sits_filters}
\alias{sits_filters}
\alias{sits_whittaker}
\alias{sits_filter}
\alias{sits_sgolay}
\title{Filter time series and data cubes}
\usage{
sits_whittaker(data = NULL, lambda = 0.5)

sits_filter(data, filter = sits_whittaker())

sits_sgolay(data = NULL, order = 3, length = 5)
}
\arguments{
\item{data}{Time series or matrix.}

\item{lambda}{Smoothing factor to be applied (default 0.5).}

\item{filter}{a filter function such as `sits_whittaker()` or
`sits_sgolay()`.}

\item{order}{Filter order (integer).}

\item{length}{Filter length (must be odd).}
}
\value{
Filtered time series
}
\description{
Filtering functions should be used with `sits_filter()`.
The following filtering functions is supported by `sits`:

`sits_whittaker()`: The algorithm searches for an optimal warping polynomial.
The degree of smoothing depends on smoothing factor lambda
(usually from 0.5 to 10.0). Use lambda = 0.5 for very slight smoothing
and lambda = 5.0 for strong smoothing.

`sits_filter()`: applies a filter to all bands.

`sits_sgolay()`: An optimal polynomial for warping a time series.
The degree of smoothing depends on the filter order (usually 3.0).
The order of the polynomial uses the parameter `order` (default = 3),
the size of the temporal window uses the parameter `length` (default = 5).
}
\examples{
# Retrieve a time series with values of NDVI
point_ndvi <- sits_select(point_mt_6bands, bands = "NDVI")

# Filter the point using the Whittaker smoother
point_whit <- sits_filter(point_ndvi, sits_whittaker(lambda = 3.0))
# Merge time series
point_ndvi <- sits_merge(point_ndvi, point_whit, suffix = c("", ".WHIT"))

# Plot the two points to see the smoothing effect
plot(point_ndvi)

# Retrieve a time series with values of NDVI
point_ndvi <- sits_select(point_mt_6bands, bands = "NDVI")

# Filter the point using the Savitzky-Golay smoother
point_sg <- sits_filter(point_ndvi,
    filter = sits_sgolay(order = 3, length = 5)
)
# Merge time series
point_ndvi <- sits_merge(point_ndvi, point_sg, suffix = c("", ".SG"))

# Plot the two points to see the smoothing effect
plot(point_ndvi)
}
\references{
Francesco Vuolo, Wai-Tim Ng, Clement Atzberger,
"Smoothing and gap-filling of high resolution multi-spectral time series:
Example of Landsat data",
Int Journal of Applied Earth Observation and Geoinformation,
vol. 57, pg. 202-213, 2107.

A. Savitzky, M. Golay, "Smoothing and Differentiation of Data by
Simplified Least Squares Procedures".
Analytical Chemistry, 36 (8): 1627–39, 1964.
}
\seealso{
\link[sits]{sits_apply}
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
