% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_validate.R
\name{sits_kfold_validate}
\alias{sits_kfold_validate}
\title{Cross-validate time series samples}
\usage{
sits_kfold_validate(
  samples,
  folds = 5,
  ml_method = sits_rfor(),
  multicores = 2
)
}
\arguments{
\item{samples}{Time series.}

\item{folds}{Number of partitions to create.}

\item{ml_method}{Machine learning method.}

\item{multicores}{Number of cores to process in parallel.}
}
\value{
A \code{caret::confusionMatrix} object to be used for
        validation assessment.
}
\description{
Splits the set of time series into training and validation and
perform k-fold cross-validation.
Cross-validation is a technique for assessing how the results
of a statistical analysis will generalize to an independent data set.
It is mainly used in settings where the goal is prediction,
and one wants to estimate how accurately a predictive model will perform.
One round of cross-validation involves partitioning a sample of data
into complementary subsets, performing the analysis on one subset
(called the training set), and validating the analysis on the other subset
(called the validation set or testing set).

The k-fold cross validation method involves splitting the dataset
into k-subsets. For each subset is held out while the model is trained
on all other subsets. This process is completed until accuracy
is determine for each instance in the dataset, and an overall
accuracy estimate is provided.

This function returns the confusion matrix, and Kappa values.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # A dataset containing a tibble with time series samples
    # for the Mato Grosso state in Brasil
    # create a list to store the results
    results <- list()

    # accuracy assessment lightTAE
    acc_ltae <- sits_kfold_validate(samples_modis_4bands,
        folds = 5,
        ml_method = sits_lighttae()
    )
    # use a name
    acc_ltae$name <- "LightTAE"
    # put the result in a list
    results[[length(results) + 1]] <- acc_ltae

    # Deep Learning - ResNet
    acc_rn <- sits_kfold_validate(samples_modis_4bands,
        folds = 5,
        ml_method = sits_resnet()
    )
    acc_rn$name <- "ResNet"
    # put the result in a list
    results[[length(results) + 1]] <- acc_rn
    # save to xlsx file
    sits_to_xlsx(results, file = "./accuracy_mato_grosso_dl.xlsx")
}

}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
