% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_cube_copy.R
\name{sits_cube_copy}
\alias{sits_cube_copy}
\title{Copy the images of a cube to a local directory}
\usage{
sits_cube_copy(
  cube,
  roi = NULL,
  res = NULL,
  multicores = 2,
  output_dir,
  progress = TRUE
)
}
\arguments{
\item{cube}{A sits cube}

\item{roi}{A Region of interest. See details below.}

\item{res}{An integer value corresponds to the output
spatial resolution of the images. Default is NULL.}

\item{multicores}{Number of workers for parallel downloading.}

\item{output_dir}{Output directory where images will be saved.}

\item{progress}{Show progress bar?}
}
\value{
a sits cube with updated metadata.
}
\description{
This function downloads the images of a cube in parallel.
A region of interest (\code{roi}) can be provided to crop
the images and a resolution (\code{res}) to resample the
bands.
}
\note{
The \code{roi} parameter defines a region of interest. It can be
   an sf_object, a shapefile, or a bounding box vector with
   named XY values ("xmin", "xmax", "ymin", "ymax") or
   named lat/long values ("lon_min", "lat_min", "lon_max", "lat_max")
}
\examples{
if (sits_run_examples()) {
  # Creating a sits cube from BDC
  bdc_cube <- sits_cube(
      source = "BDC",
      collection = "CB4-16D-2",
      tiles = c("007004", "007005"),
      bands = c("B15", "CLOUD"),
      start_date = "2018-01-01",
      end_date = "2018-01-12"
  )

  # Downloading images to a temporary directory
  cube_local <- sits_cube_copy(
      cube = bdc_cube,
      output_dir = tempdir(),
      roi = c(lon_min = -46.5,
              lat_min = -45.5,
              lon_max = -15.5,
              lat_max = -14.6),
      multicores = 2
  )
}

}
