% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_sample_functions.R
\name{sits_sampling_design}
\alias{sits_sampling_design}
\title{Allocation of sample size to strata}
\usage{
sits_sampling_design(
  cube,
  expected_ua = 0.75,
  std_err = 0.01,
  rare_class_prop = 0.1
)
}
\arguments{
\item{cube}{Classified cube}

\item{expected_ua}{Expected values of user's accuracy}

\item{std_err}{Standard error we would like to achieve}

\item{rare_class_prop}{Proportional area limit for rare classes}
}
\value{
A matrix with options to decide allocation
of sample size to each class. This matrix uses the same format as
Table 5 of Olofsson et al.(2014).
}
\description{
Takes a class cube with different labels and allocates a number of
sample sizes per strata to obtain suitable values of error-adjusted area,
providing five allocation strategies.
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # label the probability cube
    label_cube <- sits_label_classification(
        probs_cube,
        output_dir = tempdir()
    )
    # estimated UA for classes
    expected_ua <- c(Cerrado = 0.75, Forest = 0.9,
                     Pasture = 0.8, Soy_Corn = 0.8)
    sampling_design <- sits_sampling_design(label_cube, expected_ua)
}
}
\references{
[1] Olofsson, P., Foody, G.M., Stehman, S.V., Woodcock, C.E. (2013).
Making better use of accuracy data in land change studies: Estimating
accuracy and area and quantifying uncertainty using stratified estimation.
Remote Sensing of Environment, 129, pp.122-131.

[2] Olofsson, P., Foody G.M., Herold M., Stehman, S.V.,
Woodcock, C.E., Wulder, M.A. (2014)
Good practices for estimating area and assessing accuracy of land change.
Remote Sensing of Environment, 148, pp. 42-57.
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
