% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sjs.etasq}
\alias{sjs.etasq}
\title{Retrieve eta squared of fitted anova}
\usage{
sjs.etasq(...)
}
\arguments{
\item{...}{A fitted one-way-anova model or a dependent and grouping variable (see examples).}
}
\value{
The eta squared value.
}
\description{
Returns the eta squared value for 1-way-anovas.
}
\note{
Interpret eta^2 as for r2 or R2; a rule of thumb (Cohen):
        \itemize{
         \item .02 ~ small
         \item .13 ~ medium
         \item .26 ~ large
        }
}
\examples{
# load sample data
data(efc)

# fit linear model
fit <- aov(c12hour ~ as.factor(e42dep), data = efc)

# print eta sqaured
sjs.etasq(fit)

# grouping variable will be converted to factor autoamtically
sjs.etasq(efc$c12hour, efc$e42dep)
}
\references{
\itemize{
              \item \href{http://stats.stackexchange.com/questions/78808/}{stack exchange 1}
              \item \href{http://stats.stackexchange.com/questions/15958/}{stack exchange 2}
              \item \href{http://en.wikiversity.org/wiki/Eta-squared}{Wikipedia: Eta-squared}
              \item Levine TR, Hullett CR (2002): Eta Squared, Partial Eta Squared, and Misreporting of Effect Size in Communication Research (\href{https://www.msu.edu/~levinet/eta\%20squared\%20hcr.pdf}{pdf})
            }
}
\seealso{
\code{\link{sjp.aov1}}
}

