% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotPearsonsChi2Test.R
\name{sjp.chi2}
\alias{sjp.chi2}
\title{Plot Pearson's Chi2-Test of multiple contingency tables}
\usage{
sjp.chi2(df, title = "Pearson's Chi2-Test of Independence",
  axisLabels = NULL, breakTitleAt = 50, breakLabelsAt = 20,
  hideLegend = TRUE, legendTitle = NULL, printPlot = TRUE)
}
\arguments{
\item{df}{a data frame of (dichotomous) factor variables.}

\item{title}{Title of the diagram, plotted above the whole diagram panel}

\item{axisLabels}{Labels for the x- andy y-axis
axisLabels are detected automatically if each variable has
a label attribute (see \code{\link[sjmisc]{set_var_labels}}) for details).}

\item{breakTitleAt}{Wordwrap for diagram title. Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the category labels are displayed in
one line and when a line break is inserted}

\item{hideLegend}{show or hide the legend. The legend indicates the strength of correlations
by gradient colour fill.}

\item{legendTitle}{the legend title, provided as string, e.g. \code{legendTitle=c("Strength of correlation")}.
Default is \code{NULL}, hence no legend title is used.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{mydf}).
}
\description{
Plot p-values of Pearson's Chi2-tests for multiple contingency tables as ellipses or tiles.
               Requires a data frame with dichotomous (dummy) variables.
               Calculation of Chi2-matrix taken from
               \href{https://talesofr.wordpress.com/2013/05/05/ridiculously-photogenic-factors-heatmap-with-p-values/}{Tales of R}.
}
\examples{
# create data frame with 5 dichotomous (dummy) variables
mydf <- data.frame(as.factor(sample(1:2, 100, replace=TRUE)),
                   as.factor(sample(1:2, 100, replace=TRUE)),
                   as.factor(sample(1:2, 100, replace=TRUE)),
                   as.factor(sample(1:2, 100, replace=TRUE)),
                   as.factor(sample(1:2, 100, replace=TRUE)))
# create variable labels
items <- list(c("Item 1", "Item 2", "Item 3", "Item 4", "Item 5"))

# plot Chi2-contingency-table
sjp.chi2(mydf, axisLabels = items)
}
\seealso{
\href{http://talesofr.wordpress.com/2013/05/05/ridiculously-photogenic-factors-heatmap-with-p-values/}{Tales of R}.
}

