% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotCorr.R
\name{sjp.corr}
\alias{sjp.corr}
\title{Plot correlation matrix}
\usage{
sjp.corr(data, title = NULL, axis.labels = NULL, sort.corr = TRUE,
  decimals = 3, na.deletion = c("listwise", "pairwise"),
  corr.method = c("spearman", "pearson", "kendall"), geom.colors = "RdBu",
  wrap.title = 50, wrap.labels = 20, show.legend = FALSE,
  legend.title = NULL, show.values = TRUE, show.p = TRUE,
  p.numeric = FALSE, prnt.plot = TRUE)
}
\arguments{
\item{data}{matrix with correlation coefficients as returned by the 
\code{\link{cor}}-function, or a \code{data.frame} of variables where
correlations between columns should be computed.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.
For effect-plots, may also be a character vector of length > 1,
to define titles for each sub-plot or facet.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{sort.corr}{logical, if \code{TRUE} (default), the axis labels are sorted
according to the correlation strength. If \code{FALSE}, axis labels
appear in order of how variables were included in the cor-computation or
data frame.}

\item{decimals}{indicates how many decimal values after comma are printed when
the values labels are shown. Default is 3. Only applies when
\code{show.values = TRUE}.}

\item{na.deletion}{indicates how missing values are treated. May be either
\code{"listwise"} (default) or \code{"pairwise"}. May be
abbreviated.}

\item{corr.method}{indicates the correlation computation method. May be one of
\code{"spearman"} (default), \code{"pearson"} or \code{"kendall"}.
May be abbreviated.}

\item{geom.colors}{user defined color for geoms. See 'Details' in \code{\link{sjp.grpfrq}}.}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis 
labels are displayed in one line and when a line break is inserted.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{legend.title}{character vector, used as title for the plot legend.}

\item{show.values}{logical, whether values should be plotted or not.}

\item{show.p}{logical, adds significance levels to values, or value and 
variable labels.}

\item{p.numeric}{logical, if \code{TRUE}, the p-values are printed 
as numbers. If \code{FALSE} (default), asterisks are used.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}) and the original correlation matrix
          (\code{corr.matrix}).
}
\description{
Plot correlation matrix as ellipses or tiles.
}
\details{
Required argument is either a \code{\link{data.frame}} or a matrix with correlation coefficients 
           as returned by the \code{\link{cor}}-function. In case of ellipses, the
           ellipses size indicates the strength of the correlation. Furthermore,
           blue and red colors indicate positive or negative correlations, where
           stronger correlations are darker.
}
\note{
If \code{data} is a matrix with correlation coefficients as returned by 
      the \code{\link{cor}}-function, p-values can't be computed.
      Thus, \code{show.p} and \code{p.numeric}
      only have an effect if \code{data} is a \code{\link{data.frame}}.
}
\examples{
# create data frame with 5 random variables
mydf <- data.frame(cbind(runif(10), runif(10), runif(10), 
                         runif(10), runif(10)))

# plot correlation matrix
sjp.corr(mydf)

# -------------------------------
# Data from the EUROFAMCARE sample dataset
# -------------------------------
library(sjmisc)
data(efc)

# retrieve variable and value labels
varlabs <- get_label(efc)

# create data frame
vars.index <- c(1, 4, 15, 19, 20, 21, 22, 24, 25)
mydf <- data.frame(efc[, vars.index])
colnames(mydf) <- varlabs[vars.index]

# show legend
sjp.corr(mydf, show.legend = TRUE)

# -------------------------------
# auto-detection of labels
# -------------------------------
# blank theme
set_theme("blank", axis.angle.x = 90)
sjp.corr(efc[, vars.index])


}
\seealso{
\code{\link{sjt.corr}}
}
