% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjStatistics.R
\name{chisq_gof}
\alias{chisq_gof}
\title{Performs a Chi-square goodness-of-fit-test}
\usage{
chisq_gof(var, prob, weights = NULL)
}
\arguments{
\item{var}{a numeric vector / variable.}

\item{prob}{a vector of probabilities (indicating the population probabilities) of the same length
as \code{var}'s amount of categories / factor levels. Use \code{nrow(table(var))} to
determine the amount of necessary values for \code{prob}.}

\item{weights}{a vector with weights, used to weight \code{var}.}
}
\value{
(insisibly) returns the object of the computed \code{\link{chisq.test}}.
}
\description{
Performs a Chi-square goodness-of-fit-test
}
\note{
This function is a convenient function for \code{\link{chisq.test}}, performing goodness-of-fit test.
}
\examples{
data(efc)
# differing from population
chisq_gof(efc$e42dep, c(0.3,0.2,0.22,0.28))
# equal to population
chisq_gof(efc$e42dep, prop.table(table(efc$e42dep)))
}

