% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{get_val_labels}
\alias{get_val_labels}
\title{Retrieve value labels of a data frame or variable}
\usage{
get_val_labels(x, include.values = FALSE)
}
\arguments{
\item{x}{a \code{data.frame} with variables that have attached value labels (e.g.
from an imported SPSS, SAS or STATA data set, via \code{\link{read_spss}},
\code{\link{read_sas}} or \code{\link{read_stata}}); a variable
(vector) with attached value labels; or a \code{list} of variables
with attached values labels. See 'Examples'.}

\item{include.values}{logical, if \code{TRUE}, the values associated with the
value labels are returned as well (as \code{\link{names}} attribute
of the returned object).}
}
\value{
Either a list with all value labels from all variables if \code{x}
          is a \code{data.frame} or \code{list}; a string with the value
          labels, if \code{x} is a variable;
          or \code{NULL} if no value label attribute was found.
}
\description{
This function retrieves the value labels of an imported
               SPSS, SAS or STATA data set (via \code{\link{read_spss}},
               \code{\link{read_sas}} or \code{\link{read_stata}}) and
               \itemize{
                 \item if \code{x} is a data frame or list of variables, returns the all variable's value labels as \code{\link{list}}
                 \item or, if \code{x} is a vector, returns the label as string.
                 }
}
\details{
This package can add (and read) value and variable labels either in \code{foreign}
           package style (attributes are named \emph{value.labels} and \emph{variable.label})
           or in \code{haven} package style (attributes are named \emph{labels} and
           \emph{label}). By default, the \code{haven} package style is used.
           \cr \cr
           Working with labelled data is a key element of the \code{sjPlot} package,
           which accesses these attributes to automatically read label attributes
           for labelling axis categories and titles or table rows and columns.
           \cr \cr
           When working with labelled data, you can, e.g., use
           \code{\link{get_var_labels}} or \code{\link{get_val_labels}}
           to get a vector of value and variable labels, which can then be
           used with other functions like \code{\link{barplot}} etc.
           See 'Examples'.
           \cr \cr
           Furthermore, value and variable labels are used when saving data, e.g. to SPSS
           (see \code{\link{write_spss}}), which means that the written SPSS file
           contains proper labels for each variable.
           \cr \cr
           You can set a default label style (i.e. the names of the label
           attributes, see above) via \code{options(value_labels = "haven")}
           or \code{options(value_labels = "foreign")}.
}
\note{
This function only works with vectors that have value and variable
       labels attached. This is automatically done by importing data sets
       with the \code{\link{read_spss}}, \code{\link{read_sas}} or \code{\link{read_stata}}
       function. Labels can also manually be added using the \code{\link{set_val_labels}}
       and \code{\link{set_var_labels}} functions.
       \cr \cr
       With attached value and variable labels, most functions of the \code{sjPlot} package
       automatically detect labels and uses them as axis, legend or title labels
       in plots (\code{sjp.}-functions) respectively as column or row headers
       in table outputs (\code{sjt.}-functions).  See
       \href{http://www.strengejacke.de/sjPlot/datainit/}{this} and
       \href{http://www.strengejacke.de/sjPlot/labelleddata/}{this}
       online manuals for more details.
       \cr \cr
       Use \code{options(autoSetValueLabels = FALSE)}
       and \code{options(autoSetVariableLabels = FALSE)} to turn off automatic
       label detection.
}
\examples{
# import SPSS data set
# mydat <- read_spss("my_spss_data.sav", enc="UTF-8")

# retrieve variable labels
# mydat.var <- get_var_labels(mydat)

# retrieve value labels
# mydat.val <- get_val_labels(mydat)

data(efc)
get_val_labels(efc$e42dep)

# simple barplot
barplot(table(efc$e42dep))
# get value labels to annotate barplot
barplot(table(efc$e42dep),
        names.arg = get_val_labels(efc$e42dep),
        main = get_var_labels(efc$e42dep))

# include associated values
get_val_labels(efc$e42dep, TRUE)

# get labels from multiple variables
get_val_labels(list(efc$e42dep,
                    efc$e16sex,
                    efc$e15relat))
}
\seealso{
The sjPlot manual on \href{http://www.strengejacke.de/sjPlot/datainit/}{data initialization},
           \href{http://www.strengejacke.de/sjPlot/labelleddata/}{working with labelled data} or
           \href{http://www.strengejacke.de/sjPlot/view_spss/}{inspecting (SPSS imported) data frames} for
           more details; \code{\link{set_val_labels}} to manually set value labels, \code{\link{get_var_labels}}
           to get variable labels and \code{\link{get_values}} to retrieve value label associated values.
}

