% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/read_write.R
\name{read_sas}
\alias{read_sas}
\title{Import SAS dataset as data frame into R}
\usage{
read_sas(path, path.cat = NULL, atomic.to.fac = FALSE)
}
\arguments{
\item{path}{File path to the data file.}

\item{path.cat}{Optional, the file path to the SAS catalog file.}

\item{atomic.to.fac}{Logical, if \code{TRUE}, factor variables imported from
the dataset (which are imported as \code{\link{atomic}}) will be converted
to \code{\link{factor}}s.}
}
\value{
A data frame containing the SAS data. Retrieve value labels with \code{\link{get_labels}}
  and variable labels with \code{\link{get_label}}.
}
\description{
Imports data from SAS (\code{.sas7bdat}), including NA's,
               value and variable labels.
}
\note{
This is a wrapper function for \code{\link[haven]{read_sas}} function of the
        \pkg{haven} package. This function converts the imported data
        into a common class format (see \code{\link{unlabel}}).
}
\seealso{
\code{\link{read_spss}}
}

