% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{write_spss}
\alias{write_spss}
\title{Write content of data frame to SPSS sav-file}
\usage{
write_spss(x, path, enc.to.utf8 = TRUE)
}
\arguments{
\item{x}{\code{data.frame} that should be saved as file.}

\item{path}{File path of the output file.}

\item{enc.to.utf8}{Logical, if \code{TRUE}, character encoding of variable and
value labels will be converted to UTF-8.}
}
\description{
This function saves the content of a data frame to an SPSS sav-file.
}
\note{
You don't need to take care whether variables have been imported with
        the \code{\link{read_spss}} function from this package or from \pkg{haven}
        or even the \pkg{foreign} package, or if you have imported SPSS data and
        created new variables. This function does all necessary data preparation
        to write a properly labelled SPSS sav file.
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/view_spss/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{read_spss}}
           }
}

