% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_labels.R
\name{copy_labels}
\alias{copy_labels}
\title{Copy value and variable labels to (subsetted) data frames}
\usage{
copy_labels(df_new, df_origin = NULL)
}
\arguments{
\item{df_new}{The new, subsetted data frame.}

\item{df_origin}{The original data frame where the subset (\code{df_new}) stems from;
use \code{NULL}, if value and variable labels from \code{df_new} should be removed.}
}
\value{
Returns \code{df_new} with either removed value and variable label attributes
          (if \code{df_origin = NULL}) or with copied value and variable label
          attributes (if \code{df_origin} was the original subsetted data frame).
}
\description{
Subsetting-functions usually drop value and variable labels from
               subsetted data frames (if the original data frame has value and variable
               label attributes). This function copies these value and variable
               labels back to subsetted data frames that have been subsetted, for instance,
               with \code{\link{subset}}.
               \cr \cr
               In case \code{df_origin = NULL}, all possible label attributes
               from \code{df_new} are removed.
}
\note{
In case \code{df_origin = NULL}, all possible label attributes
        from \code{df_new} are removed. dplyr >= 0.4.2 no longer drops
        vector attributes; you'll only need to copy labels when using
        dplyr up to 0.4.1.
}
\examples{
data(efc)
efc.sub <- subset(efc, subset = e16sex == 1, select = c(4:8))
str(efc.sub)

efc.sub <- copy_labels(efc.sub, efc)
str(efc.sub)

efc.sub <- copy_labels(efc.sub)
str(efc.sub)

}
\seealso{
\href{http://www.strengejacke.de/sjPlot/labelleddata/}{sjPlot-manual}
           on working with labelled data, and \code{\link{remove_all_labels}} for
           removing label attributes from data frames.
}

